-- ********************************************************************
--
--   SQL File to install Quest OS/390 Products.
--
--   This file contains the SQL statements to create all Quest Central
--   for DB2 OS/390 database objects.
--
--   Before running this file through a SQL Processor, make the
--   following changes.
--
--   C ALL C'%SGNAME%' C'STOGRP'  where STOGRP is the name of the
--                                storage group for the Quest objects.
--   C ALL C'%TSBUFFPOOL%' C'TBSBUFF' where TBSBUFF is the bufferpool to
--                                to hold the tablespaces
--   C ALL C'%IXBUFFPOOL%' C'IXBUFF' where IXBUFF is the buffer to hold
--                                the indexes
--   C ALL C'%MULTTCB%' C'MULTWLM' where MULTWLM is the wlm applenv for
--                                 Quest multiple task STOPROCS and UDFS
--   C ALL C'%SINGTCB%' C'SINGWLM' where SINGWLM is the wlm applenv for
--                                 Quest single task STOPROCS and UDFS
--
-- *********************************************************************

CREATE DATABASE QCDB
  STOGROUP %SGNAME%
  BUFFERPOOL %TSBUFFPOOL%
  INDEXBP %IXBUFFPOOL%
  CCSID EBCDIC;

COMMIT WORK;

CREATE FUNCTION QUEST.QC200LISTMEMBER
 (PDSNAME CHARACTER(44) FOR SBCS DATA CCSID EBCDIC
 )              
  RETURNS TABLE 
   (MEMBER CHARACTER(9) FOR SBCS DATA CCSID EBCDIC
   )   
  SPECIFIC QUEST.QC200LISTMEMBER                                                                                 
  EXTERNAL NAME QCLSTMBR                                                                                
  LANGUAGE C                                                              
  PARAMETER STYLE DB2SQL
  NOT DETERMINISTIC
  FENCED
  RETURNS NULL ON NULL INPUT                                                  
  NO SQL                                                                  
  EXTERNAL ACTION                                                         
  SCRATCHPAD 256                                                          
  NO FINAL CALL                                                                                                                             
  DISALLOW PARALLEL
  NO DBINFO
  NO COLLID
  WLM ENVIRONMENT %MULTTCB%
  STAY RESIDENT NO                                                       
  PROGRAM TYPE SUB
  SECURITY DB2;                                                        
                                                                                                                    
COMMIT WORK;                                                                 

CREATE FUNCTION QUEST.QC200SUBSYSINFO ( ) 
  RETURNS TABLE
   (SSID VARCHAR(5) FOR SBCS DATA CCSID EBCDIC,
    DSNUM INTEGER,
    DSTYPE VARCHAR(4) FOR SBCS DATA CCSID EBCDIC,
    DSNAME VARCHAR(45) FOR SBCS DATA CCSID EBCDIC,
    RETCODE INTEGER,
    REASCODE INTEGER
   )
  SPECIFIC QUEST.QC200SUBSYSINFO
  EXTERNAL NAME QCSSINFO
  LANGUAGE C
  PARAMETER STYLE DB2SQL
  NOT DETERMINISTIC
  FENCED
  RETURNS NULL ON NULL INPUT
  READS SQL DATA
  EXTERNAL ACTION
  SCRATCHPAD 800
  FINAL CALL
  DISALLOW PARALLEL
  NO DBINFO
  COLLID %COLLID%
  WLM ENVIRONMENT %MULTTCB%
  STAY RESIDENT NO
  PROGRAM TYPE SUB
  SECURITY DB2;

COMMIT WORK;




-- Function: Spotlight IFI/READS output to client 

CREATE FUNCTION QUEST.QP450READSDIR
  ( REQTYPE0 INTEGER
  , REQTYPE1 INTEGER
  , REQTYPE2 INTEGER
  , REQTYPE3 INTEGER
  , REQTYPE4 INTEGER
  , REQTYPE5 INTEGER
  , REQTYPE6 INTEGER
  , REQTYPE7 INTEGER
  , REQTYPE8 INTEGER
  , REQTYPE9 INTEGER
  , REQTYPE10 INTEGER
  , REQTYPE11 INTEGER
  , REQTYPE12 INTEGER
  , REQTYPE13 VARCHAR(8) FOR SBCS DATA CCSID EBCDIC
  )
  RETURNS TABLE
  ( RECTYPE INTEGER
  , RECLENG INTEGER
  , TRACREC VARCHAR(32000) FOR BIT DATA CCSID EBCDIC
  )
  SPECIFIC QUEST.QP450READSDIR
  EXTERNAL NAME QPREAD45
  LANGUAGE C
  PARAMETER STYLE DB2SQL
  NOT DETERMINISTIC
  FENCED
  RETURNS NULL ON NULL INPUT
  READS SQL DATA
  EXTERNAL ACTION
  SCRATCHPAD 512
  NO FINAL CALL
  DISALLOW PARALLEL
  NO DBINFO
  COLLID %COLLID% 
  WLM ENVIRONMENT %MULTTCB%
  STAY RESIDENT YES
  PROGRAM TYPE SUB
  SECURITY DB2
  ;

COMMIT WORK;



-- Function: QC dsn subcommands    

CREATE FUNCTION QUEST.QP200DSNCOMMAND
 (DSNCOMMAND VARCHAR(32000) FOR SBCS DATA CCSID EBCDIC
 ) 
  RETURNS TABLE
   (LINENUM INTEGER,
    RETCDE INTEGER,
    REASCDE INTEGER,
    OUTPUTLINE VARCHAR(133) FOR SBCS DATA CCSID EBCDIC
   )
  SPECIFIC QUEST.QP200DSNCOMMAND
  EXTERNAL NAME QPDSNCMD
  LANGUAGE C
  PARAMETER STYLE DB2SQL
  NOT DETERMINISTIC
  FENCED
  RETURNS NULL ON NULL INPUT
  READS SQL DATA
  EXTERNAL ACTION
  SCRATCHPAD 256
  FINAL CALL
  DISALLOW PARALLEL
  NO DBINFO
  COLLID %COLLID%
  WLM ENVIRONMENT %SINGTCB%
  STAY RESIDENT YES
  PROGRAM TYPE SUB
  SECURITY USER;

COMMIT WORK;




-- Tablespace: Spotlight Recording Log

CREATE TABLESPACE QCRECLOG 
  IN QCDB                  
  USING STOGROUP %SGNAME%  
    PRIQTY 300             
    SECQTY 500             
    ERASE NO               
  FREEPAGE 0               
  PCTFREE 5                
  GBPCACHE CHANGED         
  TRACKMOD YES             
  DEFINE YES               
  LOCKSIZE ANY             
  LOCKMAX 0                
  CLOSE NO                
  COMPRESS NO              
  CCSID EBCDIC             
  MAXROWS 255;             

COMMIT WORK;



-- Tablespace: Spotlight Recording Data 

CREATE TABLESPACE QCRECTS 
  IN QCDB                 
  USING STOGROUP %SGNAME% 
    PRIQTY 3000           
    SECQTY 5000           
    ERASE NO              
  FREEPAGE 0              
  PCTFREE 5               
  GBPCACHE CHANGED        
  TRACKMOD YES            
  DEFINE YES              
  SEGSIZE 16              
  BUFFERPOOL BP32K        
  LOCKSIZE ANY            
  LOCKMAX 0               
  CLOSE NO               
  COMPRESS NO             
  CCSID EBCDIC            
  MAXROWS 255;            

COMMIT WORK;



-- Table: Spotlight Recording Log

CREATE TABLE QUEST.QCRECORD_LOG_0300                         
 (RECORDING_OWNER          CHAR   (8)   NOT NULL             
 ,RECORDING_NAME           VARCHAR(30)  NOT NULL             
 ,RECORDING_DESC           VARCHAR(30)                       
 ,RECORDING_STATUS         CHAR   (1)   NOT NULL             
 ,RECORDING_RET_CODE       INTEGER      NOT NULL             
 ,REFRESH_RATE_FG          INTEGER      NOT NULL             
 ,REFRESH_RATE_BG          INTEGER      NOT NULL             
 ,START_TIME_SCHED         TIMESTAMP    NOT NULL WITH DEFAULT
 ,START_TIME_ACTUAL        TIMESTAMP    NOT NULL WITH DEFAULT
 ,END_TIME_SCHED           TIMESTAMP    NOT NULL WITH DEFAULT
 ,END_TIME_ACTUAL          TIMESTAMP    NOT NULL WITH DEFAULT
 ,REQUESTED_SAMPLES        INTEGER      NOT NULL             
 ,SAMPLE_COUNT             INTEGER      NOT NULL             
 ,RECORDING_SIZE_REQ       INTEGER      NOT NULL             
 ,RECORDING_SIZE_ACT       INTEGER      NOT NULL             
 ,RECORDING_OPTIONS        CHAR(30)     NOT NULL             
 ,PRIMARY KEY (RECORDING_OWNER, RECORDING_NAME)              
 )                                                           
  IN QCDB.QCRECLOG                                           
  ;                                                          

COMMIT WORK;



-- Index: Spotlight Recording Log 

CREATE UNIQUE INDEX QUEST.QCRECORD_LIX_0300 
  ON QUEST.QCRECORD_LOG_0300                
 (RECORDING_OWNER ASC                       
 ,RECORDING_NAME  ASC                       
 )                                          
  USING STOGROUP %SGNAME%                    
    PRIQTY 300                              
    SECQTY 300                              
    ERASE NO                                
  FREEPAGE 5                                
  PCTFREE 10                                
  GBPCACHE CHANGED                          
  DEFINE YES                                
  CLOSE NO                                 
  DEFER YES                                 
  COPY NO                                   
  PIECESIZE 2G;                             

COMMIT WORK;



-- Table: Spotlight Recording Data

CREATE TABLE QUEST.QCRECORDING_0300                            
 (RECORDING_OWNER          CHAR   (8)   NOT NULL               
 ,RECORDING_NAME           VARCHAR(30)  NOT NULL               
 ,SNAPSHOT_SEQUENCE        INTEGER      NOT NULL               
 ,SNAPSHOT_TIMESTAMP       TIMESTAMP    NOT NULL WITH DEFAULT  
 ,REFRESH_TYPE             CHAR(1)      NOT NULL               
 ,REFRESH_SEQUENCE         INTEGER      NOT NULL               
 ,RECORDING_DATA_TYP       INTEGER      NOT NULL               
 ,RECORDING_DATA_LEN       INTEGER      NOT NULL               
 ,RECORDING_DATA           VARCHAR(32000) NOT NULL FOR BIT DATA
 ,FOREIGN KEY (RECORDING_OWNER, RECORDING_NAME)                
              REFERENCES QUEST.QCRECORD_LOG_0300               
              ON DELETE CASCADE                                
 )                                                             
  IN QCDB.QCRECTS                                              
  ;                                                            

COMMIT WORK;


                                                               
-- Index: Spotlight Recording Data

CREATE UNIQUE INDEX QUEST.QCRECORDING_X_0300                   
  ON QUEST.QCRECORDING_0300                                    
 (RECORDING_OWNER   ASC                                        
 ,RECORDING_NAME    ASC                                        
 ,REFRESH_TYPE      ASC                                        
 ,SNAPSHOT_SEQUENCE ASC                                        
 ,REFRESH_SEQUENCE  ASC                                        
 )                                                             
  USING STOGROUP %SGNAME%                                      
    PRIQTY 300                                                 
    SECQTY 300                                                 
    ERASE NO                                                   
  FREEPAGE 5                                                   
  PCTFREE 10                                                   
  GBPCACHE CHANGED                                             
  DEFINE YES                                                   
  CLOSE NO                                                    
  DEFER YES                                                    
  COPY NO                                                      
  PIECESIZE 2G;                                                

COMMIT WORK;



-- Tablespace: Spotlight Volume Space Info 

CREATE TABLESPACE QPVOLTS 
  IN QCDB   
  USING STOGROUP %SGNAME%         
    PRIQTY 500
    SECQTY 500
    ERASE  NO       
  FREEPAGE 0
  PCTFREE  5
  GBPCACHE ALL
  TRACKMOD YES
  DEFINE   YES
  SEGSIZE  32
  BUFFERPOOL %TSBUFFPOOL%
  LOCKSIZE ROW
  LOCKMAX  0
  CLOSE    NO
  COMPRESS NO
  CCSID    EBCDIC
  MAXROWS  1
  ;                               

COMMIT ;                               
                                         

                                                               
-- Table: Spotlight Volume Space Info 

CREATE TABLE QUEST.QPVOLTB                  
  ( MVSID    CHAR(4)   FOR SBCS DATA NOT NULL WITH DEFAULT
  , DB2ID    CHAR(8)   FOR SBCS DATA NOT NULL WITH DEFAULT
  , VOLID    CHAR(6)   FOR SBCS DATA NOT NULL WITH DEFAULT
  , VOLCOUNT INT       NOT NULL WITH DEFAULT
  , TRKTOTAL INT       NOT NULL WITH DEFAULT
  , TRKFREE  INT       NOT NULL WITH DEFAULT
  , PCTALLOC INT       NOT NULL WITH DEFAULT
  , TOTKB    INT       NOT NULL WITH DEFAULT
  , FREEKB   INT       NOT NULL WITH DEFAULT
  , RETCDE   INT       NOT NULL WITH DEFAULT
  , REASCDE  INT       NOT NULL WITH DEFAULT
  , CURRTIME CHAR(8)   FOR BIT DATA NOT NULL WITH DEFAULT
  , DB2COUNT SMALLINT  NOT NULL WITH DEFAULT
  , DB2INT   VARCHAR(257) FOR SBCS DATA NOT NULL WITH DEFAULT
  , SYSINT   VARCHAR(129) FOR SBCS DATA NOT NULL WITH DEFAULT
  )                                                     
  IN QCDB.QPVOLTS                                    
  DATA CAPTURE NONE
  AUDIT NONE
  CCSID EBCDIC
  ;                                                     

COMMIT ;                                                     
                                         

                                                               
-- Index: Spotlight Volume Space Info 

CREATE TYPE 2 UNIQUE INDEX
  QUEST.QPVOLTB_IX1
  ON QUEST.QPVOLTB
  ( VOLID ASC
  )
  USING STOGROUP %SGNAME%
        PRIQTY   1440
        SECQTY   1440
        ERASE    NO
  GBPCACHE   ALL
  BUFFERPOOL %IXBUFFPOOL%
  CLOSE      NO
  ;                                                     

COMMIT ;                                                     



-- Function: Spotlight Volume Space Info 

CREATE FUNCTION QUEST.QP450VOLUTIL
  ( SSNAME    VARCHAR(4) FOR SBCS DATA CCSID EBCDIC
  , FUNCCODE  INTEGER
  , SNAPSEQ   INTEGER
  , OWNER     VARCHAR(8) FOR SBCS DATA CCSID EBCDIC
  , NAME      VARCHAR(30) FOR SBCS DATA CCSID EBCDIC
  )
  RETURNS TABLE
  ( VOLSER   VARCHAR(7) FOR SBCS DATA CCSID EBCDIC
  , VOLCOUNT INTEGER
  , TRKTOTAL INTEGER
  , TRKFREE  INTEGER
  , PCTALLOC INTEGER
  , TOTKB    INTEGER
  , FREEKB   INTEGER
  , RETCODE  INTEGER
  , REASONCODE INTEGER
  , CURRTIME VARCHAR(8) FOR BIT DATA CCSID EBCDIC
  , DB2COUNT SMALLINT
  , DB2INT   VARCHAR(257) FOR SBCS DATA CCSID EBCDIC
  , SYSINT   VARCHAR(129) FOR SBCS DATA CCSID EBCDIC
  )
  SPECIFIC QUEST.QP450VOLUTIL
  EXTERNAL NAME QPVOL450
  READS SQL DATA
  LANGUAGE C
  PARAMETER STYLE DB2SQL
  NOT DETERMINISTIC
  FENCED
  RETURNS NULL ON NULL INPUT
  EXTERNAL ACTION
  SCRATCHPAD 512
  FINAL CALL
  DISALLOW PARALLEL
  DBINFO
  COLLID %COLLID%
  WLM ENVIRONMENT %MULTTCB%
  STAY RESIDENT YES
  PROGRAM TYPE SUB
  SECURITY DB2
  ;

COMMIT;



-- Tablespace: Spotlight Log Space Info 

CREATE TABLESPACE QPLOGTS 
  IN QCDB   
  USING STOGROUP %SGNAME%         
    PRIQTY 500
    SECQTY 500
    ERASE NO       
  FREEPAGE 0
  PCTFREE 5
  GBPCACHE CHANGED
  TRACKMOD YES
  DEFINE YES
  SEGSIZE 32
  BUFFERPOOL %TSBUFFPOOL%
  LOCKSIZE ROW
  LOCKMAX 0
  CLOSE NO
  COMPRESS NO
  CCSID EBCDIC
  MAXROWS 1
  ;                               

COMMIT ;                               
                                         
                                                               

-- Table: Spotlight Log Space Info 

CREATE TABLE QUEST.QPLOGTB                  
  ( MVSID    CHAR(4)  FOR SBCS DATA NOT NULL WITH DEFAULT
  , DB2ID    CHAR(8)  FOR SBCS DATA NOT NULL WITH DEFAULT
  , DUALACTS INTEGER  NOT NULL WITH DEFAULT                
  , DSN1     VARCHAR(45) FOR SBCS DATA NOT NULL WITH DEFAULT
  , DSN2     VARCHAR(45) FOR SBCS DATA NOT NULL WITH DEFAULT
  , DSN1UTIL INTEGER  NOT NULL WITH DEFAULT                
  , DSN2UTIL INTEGER  NOT NULL WITH DEFAULT                
  , NUMACTS  INTEGER  NOT NULL WITH DEFAULT                 
  , NUMFULL  INTEGER  NOT NULL WITH DEFAULT                 
  , STARTSTCK CHAR(8) FOR BIT DATA NOT NULL WITH DEFAULT
  , STARTRBA CHAR(8)  FOR BIT DATA NOT NULL WITH DEFAULT 
  , LASTRBA  CHAR(8)  FOR BIT DATA NOT NULL WITH DEFAULT  
  , CURRTIME CHAR(8)  FOR BIT DATA NOT NULL WITH DEFAULT 
  , RETCDE   INT      NOT NULL WITH DEFAULT 
  , REASCDE  INT      NOT NULL WITH DEFAULT 
  , DSN1USED INTEGER  NOT NULL WITH DEFAULT
  , DSN1TOT  INTEGER  NOT NULL WITH DEFAULT
  , DSN2USED INTEGER  NOT NULL WITH DEFAULT
  , DSN2TOT  INTEGER  NOT NULL WITH DEFAULT
  )                                                     
  IN QCDB.QPLOGTS                                    
  DATA CAPTURE NONE
  AUDIT NONE
  CCSID EBCDIC
  ;                                                     

COMMIT ;                                                     



-- Function: Spotlight Log Space Info 

CREATE FUNCTION QUEST.QP450LOGDATA
  ( SUBSYS  VARCHAR(4)  FOR SBCS DATA CCSID EBCDIC                   
  , SNAPSEQ INTEGER                     
  , OWNER   VARCHAR(8)  FOR SBCS DATA CCSID EBCDIC                    
  , NAME    VARCHAR(30) FOR SBCS DATA CCSID EBCDIC                    
  )                                    
  RETURNS TABLE
  ( DUALACTS INTEGER                 
  , DSN1     VARCHAR(45) FOR SBCS DATA CCSID EBCDIC                  
  , DSN2     VARCHAR(45) FOR SBCS DATA CCSID EBCDIC                  
  , DSN1UTIL INTEGER                  
  , DSN2UTIL INTEGER                  
  , NUMACTS  INTEGER                   
  , NUMFULL  INTEGER                   
  , STARTSTCK VARCHAR(8) FOR BIT DATA 
  , STARTRBA VARCHAR(8) FOR BIT DATA  
  , LASTRBA  VARCHAR(8) FOR BIT DATA   
  , CURRTIME VARCHAR(8) FOR BIT DATA  
  , RETCODE  INTEGER                   
  , REASCODE INTEGER                  
  , MVSID    CHAR(5) FOR SBCS DATA CCSID EBCDIC                  
  , DB2ID    CHAR(5) FOR SBCS DATA CCSID EBCDIC                  
  , DSN1USED INTEGER
  , DSN1TOT  INTEGER
  , DSN2USED INTEGER
  , DSN2TOT  INTEGER
  )                                  
  SPECIFIC QUEST.QP450LOGDATA         
  EXTERNAL NAME QPLMB450              
  READS SQL DATA
  LANGUAGE C
  PARAMETER STYLE DB2SQL
  NOT DETERMINISTIC
  FENCED
  RETURNS NULL ON NULL INPUT
  EXTERNAL ACTION
  SCRATCHPAD 512
  FINAL CALL
  DISALLOW PARALLEL
  DBINFO
  COLLID %COLLID%
  WLM ENVIRONMENT %MULTTCB%
  STAY RESIDENT YES
  PROGRAM TYPE SUB
  SECURITY DB2
  ;

COMMIT;

CREATE FUNCTION QUEST.QC200CHECKPDS
 (PDSNAME CHARACTER(44) FOR SBCS DATA CCSID EBCDIC
 )
  RETURNS TABLE
   (VALUE CHARACTER(4) FOR SBCS DATA CCSID EBCDIC
   )
  SPECIFIC QUEST.QC200CHECKPDS
  EXTERNAL NAME QCCHKPDS 
  LANGUAGE C 
  PARAMETER STYLE DB2SQL
  NOT DETERMINISTIC 
  FENCED
  RETURNS NULL ON NULL INPUT 
  NO SQL  
  EXTERNAL ACTION 
  SCRATCHPAD 256 
  NO FINAL CALL
  DISALLOW PARALLEL 
  NO DBINFO
  NO COLLID
  WLM ENVIRONMENT %MULTTCB%
  STAY RESIDENT NO
  PROGRAM TYPE SUB
  SECURITY DB2;

COMMIT WORK;

CREATE TABLESPACE QCBLUEPT
  IN QCDB
  USING STOGROUP %SGNAME%
    PRIQTY 300
    SECQTY 500
    ERASE NO
  FREEPAGE 0
  PCTFREE 5
  GBPCACHE CHANGED
  TRACKMOD YES
  DEFINE YES
  BUFFERPOOL %TSBUFFPOOL%
  LOCKSIZE ANY
  LOCKMAX 0
  CLOSE YES
  COMPRESS NO
  CCSID EBCDIC
  MAXROWS 255;

COMMIT WORK;

CREATE TABLE QUEST.QCBLUEPT_REPO030
 (NAME               VARCHAR(18) FOR SBCS DATA     NOT NULL,
  CREATOR            VARCHAR(8) FOR SBCS DATA      NOT NULL,
  DESCRIPTION        VARCHAR(50) FOR SBCS DATA     NOT NULL,
  TEMPLATE           SMALLINT                      NOT NULL,
  ONE_STMT_PER_STEP  CHARACTER(1) FOR SBCS DATA    NOT NULL,
  QUEST_STMTS        CHARACTER(1) FOR SBCS DATA    NOT NULL,
  UTIL_SYNTAX_VER    INTEGER                       NOT NULL,
  UTIL_DELIM         CHARACTER(1) FOR SBCS DATA    NOT NULL,
  CREATEDTS          TIMESTAMP                     NOT NULL  DEFAULT,
  MODIFIEDBY         VARCHAR(8) FOR SBCS DATA      NOT NULL,
  ALTEREDTS          TIMESTAMP                     NOT NULL  DEFAULT,
  RESERVED           VARCHAR(50) FOR SBCS DATA     NOT NULL  DEFAULT
  )
  IN QCDB.QCBLUEPT
  DATA CAPTURE NONE
  AUDIT NONE
  CCSID EBCDIC;

COMMIT WORK;

CREATE TABLE QUEST.QCBLUEPT_STMT030
 (NAME     VARCHAR(18) FOR SBCS DATA     NOT NULL,
  CREATOR  VARCHAR(8) FOR SBCS DATA      NOT NULL,
  SEQ      INTEGER                       NOT NULL,
  STMT     VARCHAR(100) FOR SBCS DATA    NOT NULL
 )
  IN QCDB.QCBLUEPT
  DATA CAPTURE NONE
  AUDIT NONE
  CCSID EBCDIC;

COMMIT WORK;


CREATE UNIQUE INDEX QUEST.QCBLUEPT_REPO030
  ON QUEST.QCBLUEPT_REPO030
 (NAME   ASC
 )
  USING STOGROUP %SGNAME%
    PRIQTY 12
    SECQTY 12
    ERASE NO
  FREEPAGE 0
  PCTFREE 10
  GBPCACHE CHANGED
  DEFINE YES
  BUFFERPOOL %IXBUFFPOOL%
  CLOSE YES
  DEFER NO
  COPY NO
  PIECESIZE 2097152 K;

COMMIT WORK;

CREATE UNIQUE INDEX QUEST.QCBLUEPT_STMT030
  ON QUEST.QCBLUEPT_STMT030
 (NAME      ASC,
  CREATOR   ASC,
  SEQ       ASC
 )
  USING STOGROUP %SGNAME%
    PRIQTY 12
    SECQTY 12
    ERASE NO
  FREEPAGE 0
  PCTFREE 10
  GBPCACHE CHANGED
  DEFINE YES
  BUFFERPOOL  %IXBUFFPOOL%
  CLOSE YES
  DEFER NO
  COPY NO
  PIECESIZE 2097152 K;

COMMIT WORK;

--QCEXEC blueprint
INSERT INTO QUEST.QCBLUEPT_REPO030
   (
   NAME, 
   CREATOR, 
   DESCRIPTION, 
   TEMPLATE, 
   ONE_STMT_PER_STEP, 
   QUEST_STMTS, 
   UTIL_SYNTAX_VER, 
   UTIL_DELIM, 
   CREATEDTS, 
   MODIFIEDBY, 
   ALTEREDTS, 
   RESERVED
   ) 
VALUES 
   (
   'QCEXEC', 
   'QUEST', 
   'Quest Central command execution', 
   0, 
   'N', 
   'Y', 
   7010000, 
   ';', 
   CURRENT TIMESTAMP, 
   'QUEST', 
   CURRENT TIMESTAMP, 
   ''
   );

COMMIT WORK;

INSERT INTO QUEST.QCBLUEPT_STMT030
   (
   NAME, 
   CREATOR, 
   SEQ, 
   STMT
   ) 
VALUES 
   (
   'QCEXEC', 
   'QUEST', 
   1, 
   '//*Restart Parm Description'
   );

INSERT INTO QUEST.QCBLUEPT_STMT030
   (
   NAME, 
   CREATOR, 
   SEQ, 
   STMT
   ) 
VALUES 
   (
   'QCEXEC', 
   'QUEST', 
   2, 
   '//*TARGET=%LOCATION          (1-16 char SUBSYSTEM LOCATION)'
   );

INSERT INTO QUEST.QCBLUEPT_STMT030
   (
   NAME, 
   CREATOR, 
   SEQ, 
   STMT
   ) 
VALUES 
   (
   'QCEXEC', 
   'QUEST', 
   3, 
   '//*RESTART=9999999         (7 digit sync point number for restart)'
   );

INSERT INTO QUEST.QCBLUEPT_STMT030
   (
   NAME, 
   CREATOR, 
   SEQ, 
   STMT
   ) 
VALUES 
   (
   'QCEXEC', 
   'QUEST', 
   4, 
   '//*UTIL=m:XXXXXXXXXXXXXXXX (m=CURRENT,PHASE or TERM:16 char util ID)'
   );


INSERT INTO QUEST.QCBLUEPT_STMT030
   (
   NAME, 
   CREATOR, 
   SEQ, 
   STMT
   ) 
VALUES 
   (
   'QCEXEC', 
   'QUEST', 
   5, 
   '//*TSTAMP=YYYYMMDDHHMMSS   (14 char time stamp for template datasets)'
   );

INSERT INTO QUEST.QCBLUEPT_STMT030
   (
   NAME, 
   CREATOR, 
   SEQ, 
   STMT
   ) 
VALUES 
   (
   'QCEXEC', 
   'QUEST', 
   6, 
   '//*SEQ=999999              (6 digit seq number for SM commands)'
   );

INSERT INTO QUEST.QCBLUEPT_STMT030
   (
   NAME, 
   CREATOR, 
   SEQ, 
   STMT
   ) 
VALUES 
   (
   'QCEXEC', 
   'QUEST', 
   7, 
   '//*EXAMPLE:'
   );

INSERT INTO QUEST.QCBLUEPT_STMT030
   (
   NAME, 
   CREATOR, 
   SEQ, 
   STMT
   ) 
VALUES 
   (
   'QCEXEC', 
   'QUEST', 
   8, 
   '//*PARM=(''TARGET=%LOCATION RESTART=120 UTIL=CURRENT:QCYYYYMMDDHHMMSS'','
   );

INSERT INTO QUEST.QCBLUEPT_STMT030
   (
   NAME, 
   CREATOR, 
   SEQ, 
   STMT
   ) 
VALUES 
   (
   'QCEXEC', 
   'QUEST', 
   9, 
   '//*      ''TSTAMP=YYYYMMDDHHMMSS SEQ=5'')'
   );

INSERT INTO QUEST.QCBLUEPT_STMT030
   (
   NAME, 
   CREATOR, 
   SEQ, 
   STMT
   ) 
VALUES 
   (
   'QCEXEC', 
   'QUEST', 
   10, 
   '//*'
   );

INSERT INTO QUEST.QCBLUEPT_STMT030
   (
   NAME, 
   CREATOR, 
   SEQ, 
   STMT
   ) 
VALUES 
   (
   'QCEXEC', 
   'QUEST', 
   11, 
   '//%STEP  EXEC PGM=QCEXEC,PARM=(''TARGET=%LOCATION'')'
   );

INSERT INTO QUEST.QCBLUEPT_STMT030
   (
   NAME, 
   CREATOR, 
   SEQ, 
   STMT
   ) 
VALUES 
   (
   'QCEXEC', 
   'QUEST', 
   12, 
   '%DB2LOADLIBS'
   );

INSERT INTO QUEST.QCBLUEPT_STMT030
   (
   NAME, 
   CREATOR, 
   SEQ, 
   STMT
   ) 
VALUES 
   (
   'QCEXEC', 
   'QUEST', 
   13, 
   '%MSGLIBS'
   );

INSERT INTO QUEST.QCBLUEPT_STMT030
   (
   NAME, 
   CREATOR, 
   SEQ, 
   STMT
   ) 
VALUES 
   (
   'QCEXEC', 
   'QUEST', 
   14, 
   '//QSLOG    DD SYSOUT=*'
   );

INSERT INTO QUEST.QCBLUEPT_STMT030
   (
   NAME, 
   CREATOR, 
   SEQ, 
   STMT
   ) 
VALUES 
   (
   'QCEXEC', 
   'QUEST', 
   15, 
   '//QSDBG    DD SYSOUT=*'
   );

INSERT INTO QUEST.QCBLUEPT_STMT030
   (
   NAME, 
   CREATOR, 
   SEQ, 
   STMT
   ) 
VALUES 
   (
   'QCEXEC', 
   'QUEST', 
   16, 
   '//QSSCRIPT DD *'
   );

COMMIT WORK;

--DSNUTILB blueprint
INSERT INTO QUEST.QCBLUEPT_REPO030
   (
   NAME, 
   CREATOR, 
   DESCRIPTION, 
   TEMPLATE, 
   ONE_STMT_PER_STEP, 
   QUEST_STMTS, 
   UTIL_SYNTAX_VER, 
   UTIL_DELIM, 
   CREATEDTS, 
   MODIFIEDBY, 
   ALTEREDTS, 
   RESERVED
   ) 
VALUES 
   (
   'DSNUTILB',
   'QUEST', 
   'DSNUTILB execution', 
   1, 
   'N', 
   'N', 
   7010000, 
   ';', 
   CURRENT TIMESTAMP, 
   'QUEST', 
   CURRENT TIMESTAMP, 
   ''
   );

COMMIT WORK;

INSERT INTO QUEST.QCBLUEPT_STMT030
   (
   NAME, 
   CREATOR, 
   SEQ, 
   STMT
   ) 
VALUES 
   (
   'DSNUTILB',
   'QUEST', 
   1, 
   '//UTIL     EXEC  PGM=DSNUTILB,PARM=''%SSID'',REGION=0M'
   );

INSERT INTO QUEST.QCBLUEPT_STMT030
   (
   NAME, 
   CREATOR, 
   SEQ, 
   STMT
   ) 
VALUES 
   (
   'DSNUTILB',
   'QUEST', 
   2, 
   '%DB2LOADLIBS'
   );

INSERT INTO QUEST.QCBLUEPT_STMT030
   (
   NAME, 
   CREATOR, 
   SEQ, 
   STMT
   ) 
VALUES 
   (
   'DSNUTILB',
   'QUEST', 
   3, 
   '//SYSPRINT DD  SYSOUT=*'
   );

INSERT INTO QUEST.QCBLUEPT_STMT030
   (
   NAME, 
   CREATOR, 
   SEQ, 
   STMT
   ) 
VALUES 
   (
   'DSNUTILB',
   'QUEST', 
   4, 
   '//UTPRINT DD  SYSOUT=*'
   );

INSERT INTO QUEST.QCBLUEPT_STMT030
   (
   NAME, 
   CREATOR, 
   SEQ, 
   STMT
   ) 
VALUES 
   (
   'DSNUTILB',
   'QUEST', 
   5,
   '//SYSUDUMP DD  SYSOUT=*'
   );

INSERT INTO QUEST.QCBLUEPT_STMT030
   (
   NAME, 
   CREATOR, 
   SEQ, 
   STMT
   ) 
VALUES 
   (
   'DSNUTILB',
   'QUEST', 
   6,
   '//SYSIN    DD  *'
   );

COMMIT WORK;


CREATE FUNCTION QUEST.QC200GETVOLUMEINFO
 (VOLFILTER CHARACTER(6) FOR SBCS DATA CCSID EBCDIC,
  GETSPACEINFO CHARACTER(1) FOR SBCS DATA CCSID EBCDIC,
  VOLTYPEIND CHARACTER(1) FOR SBCS DATA CCSID EBCDIC,
  UNITTYPEIND CHARACTER(5) FOR SBCS DATA CCSID EBCDIC,
  SPACETYPEIND CHARACTER(1) FOR SBCS DATA CCSID EBCDIC
 )
  RETURNS TABLE
   (VOLNAME CHARACTER(6) FOR SBCS DATA CCSID EBCDIC,
    VOLTYPE CHARACTER(1) FOR SBCS DATA CCSID EBCDIC,
    UNITTYPE CHARACTER(5) FOR SBCS DATA CCSID EBCDIC,
    TOTALSPACE INTEGER,
    PCTUSED SMALLINT,
    FREESPACE INTEGER,
    LARGESTSPACE INTEGER,
    EXTENTS INTEGER,
    TRKSPERCYL SMALLINT,
    ONLINE CHARACTER(1) FOR SBCS DATA CCSID EBCDIC,
    VOLSTORTYPE CHARACTER(7) FOR SBCS DATA CCSID EBCDIC
   )
  SPECIFIC QUEST.QC200GETVOLUMEINFO
  EXTERNAL NAME QCGETVOL
  LANGUAGE C
  PARAMETER STYLE DB2SQL
  NOT DETERMINISTIC
  FENCED
  RETURNS NULL ON NULL INPUT
  NO SQL
  EXTERNAL ACTION
  SCRATCHPAD 256
  NO FINAL CALL
  DISALLOW PARALLEL
  NO DBINFO
  NO COLLID
  WLM ENVIRONMENT %MULTTCB%
  STAY RESIDENT NO
  PROGRAM TYPE SUB
  SECURITY DB2;

COMMIT WORK;

CREATE PROCEDURE QUEST.QC45_OBJLIST_390
 (IN FUNCTION INTEGER,
  IN LISTNAME CHARACTER(18) FOR SBCS DATA CCSID EBCDIC,
  IN TRACE SMALLINT,
  OUT RETCODE INTEGER
 ) 
  DYNAMIC RESULT SETS 1
  EXTERNAL NAME QCOBJLST
  LANGUAGE C
  PARAMETER STYLE GENERAL WITH NULLS
  NOT DETERMINISTIC
  FENCED
  MODIFIES SQL DATA
  NO DBINFO
  CALLED ON NULL INPUT
  PROGRAM TYPE SUB
  COLLID %COLLID%
  WLM ENVIRONMENT %SINGTCB%
  STAY RESIDENT NO
  SECURITY USER
  RUN OPTIONS 'STACK(40960,40960,BELOW,KEEP,40960,40960)'
  COMMIT ON RETURN YES;

COMMIT WORK;
-- 
--  Quest Central - Object Lists
--  Repository creation script for DB2 on OS/390  
--

#DELIMITER ";";

CREATE TABLESPACE QCOBJLST
  IN QCDB
  USING STOGROUP %SGNAME%
    PRIQTY 12
    SECQTY 12
    ERASE NO
  FREEPAGE 0
  PCTFREE 5
  GBPCACHE CHANGED
  TRACKMOD YES
  DEFINE YES
  BUFFERPOOL %TSBUFFPOOL%
  LOCKSIZE ANY
  LOCKMAX SYSTEM
  CLOSE YES
  COMPRESS NO
  CCSID EBCDIC
  MAXROWS 255;

COMMIT WORK;

CREATE TABLE QUEST.QCOBJLIST_REPO045
 (NAME         VARCHAR(18) FOR SBCS DATA     NOT NULL,
  CREATOR      VARCHAR(8) FOR SBCS DATA      NOT NULL,
  DESCRIPTION  VARCHAR(50) FOR SBCS DATA     NOT NULL,
  SHARELEVEL   CHARACTER(1) FOR SBCS DATA    NOT NULL,
  CREATEDTS    TIMESTAMP                     NOT NULL  DEFAULT,
  MODIFIEDBY   VARCHAR(8) FOR SBCS DATA      NOT NULL,
  ALTEREDTS    TIMESTAMP                     NOT NULL  DEFAULT,
  RESERVED     VARCHAR(50) FOR SBCS DATA     NOT NULL  DEFAULT
 )
  IN QCDB.QCOBJLST
  DATA CAPTURE NONE
  AUDIT NONE
  CCSID EBCDIC;

COMMIT WORK;

CREATE UNIQUE INDEX QUEST.QCOBJLIST_REPO045
  ON QUEST.QCOBJLIST_REPO045
 (NAME   ASC
 )
  USING STOGROUP %SGNAME%
    PRIQTY 12
    SECQTY 12
    ERASE NO
  FREEPAGE 0
  PCTFREE 10
  GBPCACHE CHANGED
  DEFINE YES
  BUFFERPOOL %IXBUFFPOOL%
  CLOSE YES
  DEFER NO
  COPY NO
  PIECESIZE 2097152 K;

COMMIT WORK;

CREATE TABLE QUEST.QCOBJLIST_STMT045
 (NAME           VARCHAR(18) FOR SBCS DATA     NOT NULL,
  SEQNO          SMALLINT                      NOT NULL,
  ACTION         CHARACTER(1) FOR SBCS DATA    NOT NULL,
  RESULT_OBJECT  SMALLINT                      NOT NULL,
  COPY           CHARACTER(1) FOR SBCS DATA    NOT NULL,
  SEARCH_OBJECT  SMALLINT                      NOT NULL,
  SEARCH_FIELD1  VARCHAR(18) FOR SBCS DATA     NOT NULL,
  SEARCH_FIELD2  VARCHAR(18) FOR SBCS DATA     NOT NULL,
  PARTLEVEL      VARCHAR(256) FOR SBCS DATA    NOT NULL  DEFAULT,
  RI             CHARACTER(1) FOR SBCS DATA    NOT NULL,
  AUX_OBJECTS    CHARACTER(1) FOR SBCS DATA    NOT NULL,
  RESERVED       VARCHAR(50) FOR SBCS DATA     NOT NULL  DEFAULT
 )
  IN QCDB.QCOBJLST
  DATA CAPTURE NONE
  AUDIT NONE
  CCSID EBCDIC;

COMMIT WORK;

CREATE UNIQUE INDEX QUEST.QCOBJLIST_STMT040
  ON QUEST.QCOBJLIST_STMT045
 (NAME   ASC,
  SEQNO  ASC
 )
  USING STOGROUP %SGNAME%
    PRIQTY 12
    SECQTY 12
    ERASE NO
  FREEPAGE 0
  PCTFREE 10
  GBPCACHE CHANGED
  DEFINE YES
  BUFFERPOOL %IXBUFFPOOL%
  CLOSE YES
  DEFER NO
  COPY NO
  PIECESIZE 2097152 K;

COMMIT WORK;

--CREATE DATABASE QCTEMPDB
--  STOGROUP %SGNAME%
--  BUFFERPOOL %TSBUFFPOOL%
--  INDEXBP %IXBUFFPOOL%
--  AS TEMP;

--COMMIT WORK;

--CREATE TABLESPACE QCTEMPTS
--  IN QCTEMPDB
--  USING STOGROUP %SGNAME%
--    PRIQTY 100
--    SECQTY 200
--    ERASE NO
--  SEGSIZE 4
--  BUFFERPOOL %TSBUFFPOOL%
--  LOCKMAX SYSTEM
--  CLOSE YES
--  MAXROWS 255;

--COMMIT WORK;

-- End of generated script for Quest Central - Object Lists                                                              
CREATE PROCEDURE QUEST.QC300JFI                             
  ( IN  FUNC    CHAR(2)     FOR SBCS DATA CCSID EBCDIC,      
    IN  DATA    VARCHAR(45) FOR SBCS DATA CCSID EBCDIC,      
    IN  USERID  CHAR(8)     FOR SBCS DATA CCSID EBCDIC,      
    IN  TIMETAG TIMESTAMP,                                   
    OUT RETCODE INTEGER                                     
  )                                                         
  EXTERNAL NAME QCJFI030                                    
  LANGUAGE C                                                
  PARAMETER STYLE GENERAL                                   
  NOT DETERMINISTIC                                         
  FENCED                                                    
  MODIFIES SQL DATA                                         
  NO DBINFO                                                 
  CALLED ON NULL INPUT                                      
  RESULT SETS 1                                             
  COLLID %COLLID%                                           
  WLM ENVIRONMENT %MULTTCB%                                  
  STAY RESIDENT NO                                          
  PROGRAM TYPE MAIN                                         
  SECURITY USER                                             
  COMMIT ON RETURN NO;                                      
                                                              
COMMIT;                                                     

CREATE TABLESPACE QCJFITS 
  IN QCDB   
  USING STOGROUP %SGNAME%         
    PRIQTY 500
    SECQTY 500
    ERASE NO       
  FREEPAGE 0
  PCTFREE 5
  GBPCACHE CHANGED
  TRACKMOD YES
  DEFINE YES
  SEGSIZE 32
  BUFFERPOOL %TSBUFFPOOL%
  LOCKSIZE ROW
  LOCKMAX 0
  CLOSE YES
  COMPRESS NO
  CCSID EBCDIC
  MAXROWS 1
  ;                               

COMMIT ;                               
                                         
                                                               
CREATE TABLE QUEST.QCJFI300_INPUT                  
  ( USERID    CHAR(8)   NOT NULL WITH DEFAULT         
  , TIMEST    TIMESTAMP NOT NULL WITH DEFAULT         
  , SEQ       SMALLINT  NOT NULL WITH DEFAULT         
  , DATA      CHAR(80)  NOT NULL WITH DEFAULT         
  )                                                     
  IN QCDB.QCJFITS                                    
  DATA CAPTURE NONE
  AUDIT NONE
  CCSID EBCDIC
  ;                                                     

COMMIT ;                                                     
                                                               
CREATE TABLE QUEST.QCJFI300_OUTPUT                                 
  ( USERID    CHAR(8)   NOT NULL WITH DEFAULT         
  , TIMEST    TIMESTAMP NOT NULL WITH DEFAULT         
  , ROWTYPE   SMALLINT  NOT NULL WITH DEFAULT         
  , SEQ       SMALLINT  NOT NULL WITH DEFAULT         
  , VARDATA   VARCHAR(3900) NOT NULL WITH DEFAULT    
  )                                                     
  IN QCDB.QCJFITS                                    
  DATA CAPTURE NONE
  AUDIT NONE
  CCSID EBCDIC
  ;                                                     

COMMIT ;                                                     

CREATE FUNCTION QUEST.QC200DSVOLSTATS
 (TIMEST TIMESTAMP,
  USER CHARACTER(8) FOR SBCS DATA CCSID EBCDIC,
  FUNC SMALLINT
 ) 
  RETURNS TABLE
   (DSN CHARACTER(44) FOR SBCS DATA CCSID EBCDIC,
    VOL CHARACTER(6) FOR SBCS DATA CCSID EBCDIC,
    TOTEXT SMALLINT,
    TOTVOL SMALLINT,
    VOLNO SMALLINT,
    ERASE CHARACTER(1) FOR SBCS DATA CCSID EBCDIC,
    TYPE CHARACTER(1) FOR SBCS DATA CCSID EBCDIC,
    ALLOC INTEGER,
    USED INTEGER,
    FREE INTEGER
   )
  SPECIFIC QUEST.QC200DSVOLSTATS
  EXTERNAL NAME QCDSV
  LANGUAGE C
  PARAMETER STYLE DB2SQL
  NOT DETERMINISTIC
  FENCED
  RETURNS NULL ON NULL INPUT
  READS SQL DATA
  EXTERNAL ACTION
  SCRATCHPAD 100
  FINAL CALL
  DISALLOW PARALLEL
  DBINFO
  COLLID %COLLID%
  WLM ENVIRONMENT %MULTTCB%
  STAY RESIDENT NO
  PROGRAM TYPE SUB
  SECURITY USER;

COMMIT WORK;


--
--  CREATE QC_UTILOBJ TABLE
--
CREATE GLOBAL TEMPORARY TABLE QUEST.QC_UTILOBJ 
 (TIMEST    TIMESTAMP,
  USERID    CHARACTER(8) FOR SBCS DATA,
  UTILTYPE  CHARACTER(1) FOR SBCS DATA,
  HLQ       CHARACTER(8) FOR SBCS DATA,
  DB        CHARACTER(8) FOR SBCS DATA,
  PS        CHARACTER(8) FOR SBCS DATA,
  I         CHARACTER(1) FOR SBCS DATA,
  PART      SMALLINT,
  DSN       CHARACTER(44) FOR SBCS DATA,
  OBJTYPE   CHARACTER(1) FOR SBCS DATA,
  STATUS    CHARACTER(1) FOR SBCS DATA  
 )
  CCSID EBCDIC;

COMMIT WORK;

CREATE FUNCTION QUEST.QC200ZPARM ( ) 
  RETURNS TABLE
   (VCAT CHARACTER(8) FOR SBCS DATA CCSID EBCDIC,
    GROUPATTACHNAME CHARACTER(4) FOR SBCS DATA CCSID EBCDIC,
    GROUPNAME CHARACTER(8) FOR SBCS DATA CCSID EBCDIC,
    MEMBERNAME CHARACTER(8) FOR SBCS DATA CCSID EBCDIC,
    CHAR CHARACTER(8) FOR SBCS DATA CCSID EBCDIC,
    DECIMAL CHARACTER(1) FOR SBCS DATA CCSID EBCDIC,
    MIXED CHARACTER(1) FOR SBCS DATA CCSID EBCDIC,
    CHARSET CHARACTER(8) FOR SBCS DATA CCSID EBCDIC,
    DELIM CHARACTER(1) FOR SBCS DATA CCSID EBCDIC,
    SQLDELIM CHARACTER(1) FOR SBCS DATA CCSID EBCDIC,
    DSQLDELIM CHARACTER(1) FOR SBCS DATA CCSID EBCDIC,
    LANGUAGE CHARACTER(8) FOR SBCS DATA CCSID EBCDIC,
    DATEFMT CHARACTER(5) FOR SBCS DATA CCSID EBCDIC,
    TIMEFMT CHARACTER(5) FOR SBCS DATA CCSID EBCDIC,
    ARITHMETIC CHARACTER(2) FOR SBCS DATA CCSID EBCDIC,
    DYNAMRULES CHARACTER(1) FOR SBCS DATA CCSID EBCDIC,
    LOCNAME CHARACTER(16) FOR SBCS DATA CCSID EBCDIC,
    LUNAME CHARACTER(8) FOR SBCS DATA CCSID EBCDIC,
    TCPPORT CHARACTER(5) FOR SBCS DATA CCSID EBCDIC,
    HOST CHARACTER(254) FOR SBCS DATA CCSID EBCDIC
   )
  SPECIFIC QUEST.QC200ZPARM
  EXTERNAL NAME QCZPM
  LANGUAGE C
  PARAMETER STYLE DB2SQL
  NOT DETERMINISTIC
  FENCED
  RETURNS NULL ON NULL INPUT
  READS SQL DATA
  EXTERNAL ACTION
  SCRATCHPAD 100
  FINAL CALL
  DISALLOW PARALLEL
  DBINFO
  COLLID %COLLID%
  WLM ENVIRONMENT %MULTTCB%
  STAY RESIDENT NO
  PROGRAM TYPE SUB
  SECURITY USER;

COMMIT WORK;

-- 
--  Quest Central - Reports
--  Repository creation script for DB2 on OS/390  
--

#DELIMITER ";";

#SYNC 10;

CREATE TABLESPACE QCRPT
  IN QCDB
  USING STOGROUP %SGNAME%
    PRIQTY 300
    SECQTY 500
    ERASE NO
  FREEPAGE 0
  PCTFREE 5
  GBPCACHE CHANGED
  TRACKMOD YES
  DEFINE YES
  BUFFERPOOL %TSBUFFPOOL%
  LOCKSIZE ANY
  LOCKMAX SYSTEM
  CLOSE YES
  COMPRESS NO
  CCSID EBCDIC
  MAXROWS 255;

COMMIT WORK;

CREATE TABLE QUEST.QCREPORT_REPO045
 (RPT_NAME       CHARACTER(30) FOR SBCS DATA   NOT NULL,
  RPT_CREATOR    VARCHAR(128) FOR SBCS DATA    NOT NULL DEFAULT CURRENT SQLID,
  RPT_TIMESTAMP  TIMESTAMP                     NOT NULL,
  FILENAME       VARCHAR(200) FOR SBCS DATA,
  FILE_TYPE      VARCHAR(100) FOR SBCS DATA,
  ROWID          ROWID                         NOT NULL  GENERATED ALWAYS
 )
  IN QCDB.QCRPT
  DATA CAPTURE NONE
  AUDIT NONE
  CCSID EBCDIC;

COMMIT WORK;

CREATE UNIQUE INDEX QUEST.QCREPORT_REPO_IX
  ON QUEST.QCREPORT_REPO045
 (RPT_NAME        ASC,
  RPT_CREATOR     ASC,
  RPT_TIMESTAMP   ASC
 )
  USING STOGROUP %SGNAME%
    PRIQTY 12
    SECQTY 12
    ERASE NO
  FREEPAGE 0
  PCTFREE 10
  GBPCACHE CHANGED
  DEFINE YES
  BUFFERPOOL %IXBUFFPOOL%
  CLOSE YES
  DEFER NO
  COPY NO
  PIECESIZE 2097152 K;

COMMIT WORK;

CREATE TABLE QUEST.QCREPORT_DETAIL045
 (RPT_NAME       CHARACTER(30) FOR SBCS DATA    NOT NULL,
  RPT_CREATOR    VARCHAR(128) FOR SBCS DATA     NOT NULL DEFAULT CURRENT SQLID,
  RPT_TIMESTAMP  TIMESTAMP                      NOT NULL,
  FILENAME       VARCHAR(200) FOR SBCS DATA,
  SEQUENCE       INTEGER,
  RPT_DATA       CLOB(65536) FOR SBCS DATA      NOT NULL,
  ROWID          ROWID                          NOT NULL  GENERATED ALWAYS
 )
  IN QCDB.QCRPT;

COMMIT WORK;

CREATE INDEX QUEST.QCREPORT_DET_IX
  ON QUEST.QCREPORT_DETAIL045
 (RPT_NAME        ASC,
  RPT_CREATOR     ASC,
  RPT_TIMESTAMP   ASC
 )
  USING STOGROUP %SGNAME%
    PRIQTY 12
    SECQTY 12
    ERASE NO
  FREEPAGE 0
  PCTFREE 10
  GBPCACHE CHANGED
  DEFINE YES
  BUFFERPOOL %IXBUFFPOOL%
  CLOSE YES
  DEFER NO
  COPY YES
  PIECESIZE 2097152 K;

COMMIT WORK;

--- AUXILIARY OBJECTS

-- Tablespace

CREATE LOB TABLESPACE QCLOBAUX
  IN QCDB
  USING STOGROUP %SGNAME%
    PRIQTY 7200
    SECQTY 7200
    ERASE NO
  GBPCACHE CHANGED
  LOG YES
  DEFINE YES
  DSSIZE 4 G
  BUFFERPOOL %TSBUFFPOOL%
  LOCKSIZE ANY
  LOCKMAX SYSTEM
  CLOSE YES;

COMMIT WORK;

-- Table

CREATE AUXILIARY TABLE QUEST.QC_LOBAUXTB045
  IN QCDB.QCLOBAUX
  STORES QUEST.QCREPORT_DETAIL045 
  COLUMN RPT_DATA;

COMMIT WORK;

-- Index

CREATE UNIQUE INDEX QUEST.QCLOBAUX045IX
  ON QUEST.QC_LOBAUXTB045
  USING STOGROUP %SGNAME%
    PRIQTY 12
    SECQTY 12
    ERASE NO
  FREEPAGE 0
  PCTFREE 10
  GBPCACHE CHANGED
  DEFINE YES
  BUFFERPOOL %IXBUFFPOOL%
  CLOSE YES
  COPY NO
  PIECESIZE 2097152 K;

COMMIT WORK;



#SYNC 20;

--  create UDF for getting volume info
--
CREATE FUNCTION QUEST.QC200STOGROUPVOLS
 (SGNAME CHARACTER(8) FOR SBCS DATA CCSID EBCDIC,
  GETSPACEINFO CHARACTER(1) FOR SBCS DATA CCSID EBCDIC,
  SPACETYPEIND CHARACTER(1) FOR SBCS DATA CCSID EBCDIC
 )
  RETURNS TABLE
   (VOLNAME CHARACTER(6) FOR SBCS DATA CCSID EBCDIC,
    VOLTYPE CHARACTER(1) FOR SBCS DATA CCSID EBCDIC,
    UNITTYPE CHARACTER(5) FOR SBCS DATA CCSID EBCDIC,
    TOTALSPACE INTEGER,
    PCTUSED SMALLINT,
    FREESPACE INTEGER,
    LARGESTSPACE INTEGER,
    EXTENTS INTEGER,
    TRKSPERCYL SMALLINT,
    ONLINE CHARACTER(1) FOR SBCS DATA CCSID EBCDIC,
    VOLSTORTYPE CHARACTER(7) FOR SBCS DATA CCSID EBCDIC
   )
  SPECIFIC QUEST.QC200STOGROUPVOLS
  EXTERNAL NAME QCSTOVOL
  LANGUAGE C
  PARAMETER STYLE DB2SQL
  NOT DETERMINISTIC
  FENCED
  RETURNS NULL ON NULL INPUT
  READS SQL DATA
  EXTERNAL ACTION
  SCRATCHPAD 256
  NO FINAL CALL
  DISALLOW PARALLEL
  NO DBINFO
  COLLID %COLLID%
  WLM ENVIRONMENT %MULTTCB%
  STAY RESIDENT NO
  PROGRAM TYPE SUB
  SECURITY DB2;

COMMIT WORK;

CREATE TABLESPACE QCTEMPLT
  IN QCDB
  USING STOGROUP %SGNAME%
    PRIQTY 300
    SECQTY 500
    ERASE NO
  FREEPAGE 0
  PCTFREE 5
  GBPCACHE CHANGED
  TRACKMOD YES
  DEFINE YES
  SEGSIZE 16
  BUFFERPOOL %TSBUFFPOOL%
  LOCKSIZE ANY
  LOCKMAX 0
  CLOSE YES
  COMPRESS NO
  CCSID EBCDIC
  MAXROWS 255;

COMMIT WORK;


CREATE TABLE QUEST.QCTEMPLATE_REPO200
 (NAME          VARCHAR(18) FOR SBCS DATA     NOT NULL,
  CREATEDBY     VARCHAR(8) FOR SBCS DATA      NOT NULL,
  MODIFIEDBY    VARCHAR(8) FOR SBCS DATA      NOT NULL,
  DSNMASK       VARCHAR(254) FOR SBCS DATA    NOT NULL,
  DISPSTATUS    VARCHAR(3) FOR SBCS DATA      NOT NULL,
  DISPNORMAL    VARCHAR(7) FOR SBCS DATA      NOT NULL,
  DISPABNORMAL  VARCHAR(7) FOR SBCS DATA      NOT NULL,
  DEVICETYPE    VARCHAR(8) FOR SBCS DATA      NOT NULL,
  MODELDCB      VARCHAR(54) FOR SBCS DATA     NOT NULL,
  BUFNO         SMALLINT                      NOT NULL,
  VOLCOUNT      SMALLINT                      NOT NULL,
  DATACLAS      VARCHAR(8) FOR SBCS DATA      NOT NULL,
  MGMTCLAS      VARCHAR(8) FOR SBCS DATA      NOT NULL,
  STORCLAS      VARCHAR(8) FOR SBCS DATA      NOT NULL,
  DSVOLSER      VARCHAR(1784) FOR SBCS DATA   NOT NULL,
  GDGLIMIT      SMALLINT                      NOT NULL,
  EXPDL         VARCHAR(7) FOR SBCS DATA      NOT NULL,
  RETPD         SMALLINT                      NOT NULL,
  UNITTYPE      CHARACTER(1) FOR SBCS DATA    NOT NULL,
  PQTY          INTEGER                       NOT NULL,
  SQTY          INTEGER                       NOT NULL,
  SPACEUNIT     CHARACTER(5) FOR SBCS DATA    NOT NULL,
  PCTPRIMARY    SMALLINT                      NOT NULL,
  PCTSECONDARY  SMALLINT                      NOT NULL,
  MAXPRIMARY    INTEGER                       NOT NULL,
  NBRSECONDARY  SMALLINT                      NOT NULL,
  UNITCOUNT     SMALLINT                      NOT NULL,
  STACK         CHARACTER(1) FOR SBCS DATA    NOT NULL,
  JES3DD        VARCHAR(8) FOR SBCS DATA      NOT NULL,
  TRTCH         VARCHAR(6) FOR SBCS DATA      NOT NULL,
  REMARKS       VARCHAR(254) FOR SBCS DATA    NOT NULL,
  A1            VARCHAR(1000) FOR BIT DATA    NOT NULL
 )
  IN QCDB.QCTEMPLT
  DATA CAPTURE NONE
  AUDIT NONE
  CCSID EBCDIC;

COMMIT WORK;


CREATE UNIQUE INDEX QUEST.QCTEMPLATE_REPO200
  ON QUEST.QCTEMPLATE_REPO200
 (NAME   ASC
 )
  USING STOGROUP %SGNAME%
    PRIQTY 300
    SECQTY 300
    ERASE NO
  FREEPAGE 0
  PCTFREE 10
  GBPCACHE CHANGED
  DEFINE YES
  BUFFERPOOL %IXBUFFPOOL%
  CLOSE YES
  DEFER YES
  COPY NO
  PIECESIZE 2097152 K;

COMMIT WORK;


--Sm Reorg Unload Template
INSERT INTO QUEST.QCTEMPLATE_REPO200 VALUES
 ('QCUNLDDN', 'QUEST', 'QUEST',
  '&USERID..&SSID..&DB..&TS..T&TIME..U',
  '', '', '', '', '', 0, 0,
  '', '', '', '', 0, '', 0, 'D',
  100, 500, 'TRK', 0, 0, 0, 0,
  0, 'N', '', '',
  'Used for Reorg unload dataset', ''
 );

COMMIT WORK;


--Sortin Template
INSERT INTO QUEST.QCTEMPLATE_REPO200 VALUES
 ('QCSORTIN', 'QUEST', 'QUEST',
  '&USERID..&SSID..&DB..&TS..T&TIME..I',
  '', '', '', '', '', 0, 0,
  '', '', '', '', 0, '', 0, 'D',
  100, 500, 'TRK', 0, 0, 0, 0,
  0, 'N', '', '',
  'Used for sortin work dataset', ''
 );

COMMIT WORK;


--Sortout Template
INSERT INTO QUEST.QCTEMPLATE_REPO200 VALUES
 ('QCSORTO', 'QUEST', 'QUEST',
  '&USERID..&SSID..&DB..&TS..T&TIME..O',
  '', '', '', '', '', 0, 0,
  '', '', '', '', 0, '', 0, 'D',
  100, 500, 'TRK', 0, 0, 0, 0,
  0, 'N', '', '',
  'Used for sortout work dataset', ''
 );

COMMIT WORK;


--Image Copy Template
INSERT INTO QUEST.QCTEMPLATE_REPO200 VALUES
 ('QCCPY1', 'QUEST', 'QUEST',
  '&USERID..&SSID..&DB..&TS..T&TIME..LP',
  '', '', '', '', '', 0, 0,
  '', '', '', '', 0, '', 0, 'D',
  100, 500, 'TRK', 0, 0, 0, 0,
  0, 'N', '', '',
  'Used for primary local image copies', ''
 );

COMMIT WORK;


--Image Copy Template
INSERT INTO QUEST.QCTEMPLATE_REPO200 VALUES
 ('QCCPY2', 'QUEST', 'QUEST',
  '&USERID..&SSID..&DB..&TS..T&TIME..LS',
  '', '', '', '', '', 0, 0,
  '', '', '', '', 0, '', 0, 'D',
  100, 500, 'TRK', 0, 0, 0, 0,
  0, 'N', '', '',
  'Used for secondary local image copies', ''
 );

COMMIT WORK;


--Image Copy Template
INSERT INTO QUEST.QCTEMPLATE_REPO200 VALUES
 ('QCRCPY1', 'QUEST', 'QUEST',
  '&USERID..&SSID..&DB..&TS..T&TIME..RP',
  '', '', '', '', '', 0, 0,
  '', '', '', '', 0, '', 0, 'D',
  100, 500, 'TRK', 0, 0, 0, 0,
  0, 'N', '', '',
  'Used for primary remote image copies', ''
 );

COMMIT WORK;


--Image Copy Template
INSERT INTO QUEST.QCTEMPLATE_REPO200 VALUES
 ('QCRCPY2', 'QUEST', 'QUEST',
  '&USERID..&SSID..&DB..&TS..T&TIME..RS',
  '', '', '', '', '', 0, 0,
  '', '', '', '', 0, '', 0, 'D',
  100, 500, 'TRK', 0, 0, 0, 0,
  0, 'N', '', '',
  'Used for secondary remote image copies', ''
 );

COMMIT WORK;


--Error Template
INSERT INTO QUEST.QCTEMPLATE_REPO200 VALUES
 ('QCERROR', 'QUEST', 'QUEST',
  '&USERID..&SSID..&DB..&TS..T&TIME..ER',
  '', '', '', '', '', 0, 0,
  '', '', '', '', 0, '', 0, 'D',
  100, 500, 'TRK', 0, 0, 0, 0,
  0, 'N', '', '',
  'Used for error processing dataset', ''
 );

COMMIT WORK;

--Mapping Template
INSERT INTO QUEST.QCTEMPLATE_REPO200 VALUES
 ('QCMAP', 'QUEST', 'QUEST',
  '&USERID..&SSID..&DB..&TS..T&TIME..MAP',
  '', '', '', '', '', 0, 0,
  '', '', '', '', 0, '', 0, 'D',
  100, 500, 'TRK', 0, 0, 0, 0,
  0, 'N', '', '',
  'Used for mapping dataset', ''
 );

COMMIT WORK;

--Discard Template
INSERT INTO QUEST.QCTEMPLATE_REPO200 VALUES
 ('QCDISC', 'QUEST', 'QUEST',
  '&USERID..&SSID..&DB..&TS..T&TIME..DISC',
  '', '', '', '', '', 0, 0,
  '', '', '', '', 0, '', 0, 'D',
  100, 500, 'TRK', 0, 0, 0, 0,
  0, 'N', '', '',
  'Used for discard dataset', ''
 );

COMMIT WORK;

CREATE PROCEDURE QUEST.QC200EXECUTE_UTIL 
 (IN USERID VARCHAR(8) FOR SBCS DATA CCSID EBCDIC,
  IN TIMETAG TIMESTAMP,
  IN UTILID VARCHAR(16) FOR SBCS DATA CCSID EBCDIC,
  IN UTILITY_NAME VARCHAR(20) FOR SBCS DATA CCSID EBCDIC,
  IN RESTART VARCHAR(8) FOR SBCS DATA CCSID EBCDIC,
  IN STATEMENT VARCHAR(32704) FOR SBCS DATA CCSID EBCDIC,
  IN A1 VARCHAR(1000) FOR SBCS DATA CCSID EBCDIC,
  OUT RETCODE INTEGER 
 )
  DYNAMIC RESULT SETS 1
  EXTERNAL NAME QCUTIL
  LANGUAGE C
  PARAMETER STYLE GENERAL
  NOT DETERMINISTIC
  FENCED
  MODIFIES SQL DATA
  NO DBINFO
  CALLED ON NULL INPUT
  PROGRAM TYPE MAIN
  COLLID %COLLID%
  WLM ENVIRONMENT %SINGTCB%
  STAY RESIDENT NO
  SECURITY USER
  RUN OPTIONS 'TRAP(OFF)'
  COMMIT ON RETURN NO;

COMMIT WORK;


CREATE TABLESPACE QCUTLIN
  IN QCDB
  USING STOGROUP %SGNAME%
    PRIQTY 500
    SECQTY 500
    ERASE NO
  FREEPAGE 0
  PCTFREE 5
  GBPCACHE CHANGED
  TRACKMOD YES
  DEFINE YES
  SEGSIZE 16
  BUFFERPOOL %TSBUFFPOOL%
  LOCKSIZE ROW
  LOCKMAX 0
  CLOSE YES
  COMPRESS NO
  CCSID EBCDIC
  MAXROWS 1;

COMMIT WORK;


CREATE TABLE QUEST.QCUTL200_TEMPLATES
 (SEQNO         INTEGER                      NOT NULL,
  USERID        VARCHAR(8) FOR SBCS DATA     NOT NULL,
  TIMETAG       TIMESTAMP                    NOT NULL,
  NAME          VARCHAR(18) FOR SBCS DATA    NOT NULL,
  DATASET       VARCHAR(44) FOR SBCS DATA    NOT NULL,
  DEVTYPE       VARCHAR(8) FOR SBCS DATA     NOT NULL,
  MODELDCB      VARCHAR(44) FOR SBCS DATA    NOT NULL,
  BUFNO         INTEGER                      NOT NULL,
  DATACLAS      VARCHAR(8) FOR SBCS DATA     NOT NULL,
  MGMTCLAS      VARCHAR(8) FOR SBCS DATA     NOT NULL,
  STORCLAS      VARCHAR(8) FOR SBCS DATA     NOT NULL,
  RETPD         INTEGER                      NOT NULL,
  EXPDATE       VARCHAR(7) FOR SBCS DATA     NOT NULL,
  VOLCOUNT      INTEGER                      NOT NULL,
  GDGLIMIT      INTEGER                      NOT NULL,
  DISPSTATUS    VARCHAR(8) FOR SBCS DATA     NOT NULL,
  DISPNORMAL    VARCHAR(8) FOR SBCS DATA     NOT NULL,
  DISPABNORMAL  VARCHAR(8) FOR SBCS DATA     NOT NULL,
  SPACEUNIT     VARCHAR(5) FOR SBCS DATA     NOT NULL,
  PRIMARY       INTEGER                      NOT NULL,
  SECONDARY     INTEGER                      NOT NULL,
  PCTPRIMARY    INTEGER                      NOT NULL,
  PCTSECONDARY  INTEGER                      NOT NULL,
  MAXPRIMARY    INTEGER                      NOT NULL,
  NBRSECONDARY  INTEGER                      NOT NULL,
  UNITCOUNT     INTEGER                      NOT NULL,
  STACK         VARCHAR(2) FOR SBCS DATA     NOT NULL,
  JES3DD        VARCHAR(8) FOR SBCS DATA     NOT NULL,
  TRTCH         VARCHAR(6) FOR SBCS DATA     NOT NULL,
  UNITTYPE      VARCHAR(2) FOR SBCS DATA     NOT NULL,
  DDTYPE        VARCHAR(9) FOR SBCS DATA     NOT NULL,
  VOLUMES       VARCHAR(1784) FOR SBCS DATA  NOT NULL,
  A1            VARCHAR(1000) FOR SBCS DATA  NOT NULL
 )
  IN QCDB.QCUTLIN
  DATA CAPTURE NONE
  AUDIT NONE
  CCSID EBCDIC;

COMMIT WORK;


CREATE TABLESPACE QCUTLOUT
  IN QCDB
  USING STOGROUP %SGNAME%
    PRIQTY 1000
    SECQTY 2000
    ERASE NO
  FREEPAGE 0
  PCTFREE 5
  GBPCACHE CHANGED
  TRACKMOD YES
  DEFINE YES
  SEGSIZE 16
  BUFFERPOOL %TSBUFFPOOL%
  LOCKSIZE ANY
  LOCKMAX 0
  CLOSE YES
  COMPRESS NO
  CCSID EBCDIC
  MAXROWS 255;

COMMIT WORK;


CREATE TABLE QUEST.QCUTL200_OUTPUT
 (SEQNO    INTEGER                       NOT NULL,
  USERID   VARCHAR(8) FOR SBCS DATA      NOT NULL,
  TIMETAG  TIMESTAMP                     NOT NULL,
  TEXT     VARCHAR(2000) FOR SBCS DATA   NOT NULL
 )
  IN QCDB.QCUTLOUT
  DATA CAPTURE NONE
  AUDIT NONE
  CCSID EBCDIC;

COMMIT WORK;

CREATE PROCEDURE QUEST.QC450RETHLQ
 (OUT HLQ VARCHAR(44) FOR SBCS DATA CCSID EBCDIC
 ) 
  EXTERNAL NAME QPRETHLQ
  LANGUAGE C
  PARAMETER STYLE DB2SQL
  NOT DETERMINISTIC
  FENCED
  MODIFIES SQL DATA
  NO DBINFO
  CALLED ON NULL INPUT
  PROGRAM TYPE SUB
  COLLID %COLLID%
  WLM ENVIRONMENT %MULTTCB%
  STAY RESIDENT NO
  SECURITY USER
  COMMIT ON RETURN NO;



CREATE FUNCTION QUEST.QC200COMMAND
 (COMMAND VARCHAR(32000) FOR SBCS DATA CCSID EBCDIC
 ) 
  RETURNS TABLE
   (RETCODE INTEGER,
    REASCODE INTEGER,
    TEXTLIN VARCHAR(255) FOR SBCS DATA CCSID EBCDIC
   )
  SPECIFIC QUEST.QC200COMMAND
  EXTERNAL NAME QCDB2CMD
  LANGUAGE C
  PARAMETER STYLE DB2SQL
  NOT DETERMINISTIC
  FENCED
  RETURNS NULL ON NULL INPUT
  READS SQL DATA
  EXTERNAL ACTION
  SCRATCHPAD 256
  FINAL CALL
  DISALLOW PARALLEL
  DBINFO
  COLLID %COLLID%
  WLM ENVIRONMENT %MULTTCB%
  STAY RESIDENT NO
  PROGRAM TYPE SUB
  SECURITY DB2;

COMMIT WORK;

CREATE PROCEDURE QUEST.QC200SQLMSG
 (IN SQLCODE INTEGER,
  IN SQLERRML SMALLINT,
  IN SQLERRMC VARCHAR(70) FOR SBCS DATA CCSID EBCDIC,
  IN SQLERRP VARCHAR(8) FOR SBCS DATA CCSID EBCDIC,
  IN SQLERRD0 INTEGER,
  IN SQLERRD1 INTEGER,
  IN SQLERRD2 INTEGER,
  IN SQLERRD3 INTEGER,
  IN SQLERRD4 INTEGER,
  IN SQLERRD5 INTEGER,
  IN SQLWARN VARCHAR(11) FOR SBCS DATA CCSID EBCDIC,
  IN SQLSTATE VARCHAR(5) FOR SBCS DATA CCSID EBCDIC,
  OUT MSGTEXT VARCHAR(1210) FOR SBCS DATA CCSID EBCDIC
 ) 
  EXTERNAL NAME QCSQLMSG
  LANGUAGE ASSEMBLE
  PARAMETER STYLE GENERAL WITH NULLS
  NOT DETERMINISTIC
  FENCED
  MODIFIES SQL DATA
  NO DBINFO
  CALLED ON NULL INPUT
  PROGRAM TYPE SUB
  NO COLLID
  WLM ENVIRONMENT %MULTTCB%
  STAY RESIDENT NO
  SECURITY USER
  COMMIT ON RETURN NO;

COMMIT WORK;

CREATE FUNCTION QUEST.QCVER ( ) 
  RETURNS TABLE
   (VERSION VARCHAR(255) FOR SBCS DATA CCSID EBCDIC
   )
  SPECIFIC QUEST.QCVER
  EXTERNAL NAME QCVER
  LANGUAGE C
  PARAMETER STYLE DB2SQL
  NOT DETERMINISTIC
  FENCED
  RETURNS NULL ON NULL INPUT
  NO SQL
  EXTERNAL ACTION
  SCRATCHPAD 100
  FINAL CALL
  DISALLOW PARALLEL
  DBINFO
  NO COLLID 
  WLM ENVIRONMENT %MULTTCB%
  STAY RESIDENT NO
  PROGRAM TYPE SUB
  SECURITY USER;

COMMIT WORK;


CREATE VIEW QUEST.SM_TABLEPART as
  SELECT
    PARTITION,
    TSNAME,
    DBNAME,
    PQTY,
    SECQTYI,
    FARINDREF,
    NEARINDREF,
    PERCACTIVE,
    PERCDROP,
    SPACEF,
    PAGESAVE,
    STATSTIME,
    CARDF,
    EXTENTS,
    DSNUM,
    IBMREQD
  FROM SYSIBM.SYSTABLEPART_HIST;

COMMIT;

CREATE VIEW QUEST.SM_TABLES as
  SELECT
    NAME,
    CREATOR,
    DBNAME,
    TSNAME,
    COLCOUNT,
    PCTPAGES,
    PCTROWCOMP,
    STATSTIME,
    CARDF,
    NPAGESF,
    AVGROWLEN,
    SPACEF,
    IBMREQD
  FROM SYSIBM.SYSTABLES_HIST;

COMMIT;

CREATE VIEW QUEST.SM_INDEXPART as
  SELECT
    PARTITION,
    IXNAME,
    IXCREATOR,
    PQTY,
    SECQTYI,
    LEAFDIST,
    SPACEF,
    STATSTIME,
    FAROFFPOSF,
    NEAROFFPOSF,
    CARDF,
    EXTENTS,
    PSEUDO_DEL_ENTRIES,
    DSNUM,
    IBMREQD,
    LEAFNEAR,
    LEAFFAR
  FROM SYSIBM.SYSINDEXPART_HIST;

COMMIT;

CREATE VIEW QUEST.SM_INDEXES as
  SELECT
    NAME,
    CREATOR,
    TBNAME,
    TBCREATOR,
    CLUSTERING,
    NLEAF,
    NLEVELS,
    STATSTIME,
    FIRSTKEYCARDF,
    FULLKEYCARDF,
    CLUSTERRATIOF,
    SPACEF,
    IBMREQD
   FROM SYSIBM.SYSINDEXES_HIST;

COMMIT;
